﻿' 注意: 如果更改此处的类名“Feed1”，也必须更新 App.config 中对“Feed1”的引用。
Public Class Feed1
    Implements IFeed1

    Public Function CreateFeed() As SyndicationFeedFormatter Implements IFeed1.CreateFeed
        ' 新建整合源。
        Dim feed As SyndicationFeed = New SyndicationFeed("Feed Title", "A WCF Syndication Feed", Nothing)
        Dim items As List(Of SyndicationItem) = New List(Of SyndicationItem)()

        ' 新建整合项。
        Dim item As SyndicationItem = New SyndicationItem("An item", "Item content", Nothing)
        items.Add(item)
        feed.Items = items

        ' 根据查询字符串返回 ATOM 或 RSS
        ' rss -> http://localhost:8731/Design_Time_Addresses/$safeprojectname$/Feed1/
        ' atom -> http://localhost:8731/Design_Time_Addresses/$safeprojectname$/Feed1/?format=atom
        Dim query As String = WebOperationContext.Current.IncomingRequest.UriTemplateMatch.QueryParameters.Get("format")
        Dim formatter As SyndicationFeedFormatter = Nothing
        If (query = "atom") Then
            formatter = New Atom10FeedFormatter(feed)
        Else
            formatter = New Rss20FeedFormatter(feed)
        End If

        Return formatter
    End Function

End Class
